/*
 * serial interface library
 */

#define MAXRETRY	2	/* max. open restry */
#define TIMEOUT		3

static struct sigaction saalrm, osaalrm;

static void onalrm(int);

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>

static struct sockaddr_in sv_addr;

static struct hostent *shost;

static char srv_addr[80];

int serOpen(host, port) char *host;
{
  int i, sofd;


  for (i = 0; i < MAXRETRY; i++) {
	strcpy(srv_addr, host);	/* IP Address */
	saalrm.sa_handler = onalrm;
	sigemptyset(&saalrm.sa_mask);
	saalrm.sa_flags = 0;
	sigaction(SIGALRM, &saalrm, &osaalrm);
	alarm(TIMEOUT);
	if ((sofd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
		error("socket() failed", (char *)0);
	if ((shost = gethostbyname(srv_addr)) == NULL)
		error("gethostbyname() failed", (char *)0);
	memset((char *)&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port = htons(port);
	memcpy((char *)&sv_addr.sin_addr, (char *)shost->h_addr,
		shost->h_length);
	if (connect(sofd, (struct sockaddr *)&sv_addr, sizeof(sv_addr)) < 0) {
		close(sofd);
		sleep(1);
		continue;
	}
	alarm(0);
	break;
  }
  if (i == MAXRETRY)
	return -1;
  usleep(10000);
  return sofd;
}

int serClose(fd)
{
  if (shutdown(fd, 2) < 0)
        error("shutdown() failed", (char *)0);
  if (close(fd) < 0)
	error("cose(%d) failed", fd);
  return 0;
}

static void onalrm(i)
{
  saalrm.sa_handler = onalrm;
  sigemptyset(&saalrm.sa_mask);
  saalrm.sa_flags = 0;
  sigaction(SIGALRM, &saalrm, &osaalrm);
}
