/*
 * WR3381K - ե룲⥳
 * 2015-12-25, 2016-01-10 Kouichi Hirabayashi
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>
#include <termios.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/uio.h>

void Usage();
void error(char *, char *);
int dump(char *, int);
int ckError();
int reset();
int enq();
int ckerror();
int disable();
int begin();
int onoff(int);
int red(int);
int Red(int, int);
int check();
int getptn(int);
int getgrp(int);
int clrptgr();
int Recv(int, char *, int);
int serOpen(char *, int);
int serClose(int);
//int setgrp(int, int, ...);
int setgrp(int, int *);
int arg2adr(char*);

#define HOST	"192.168.3.40"	// NPort5450#1 9600,8,1,No
#define PORT	4001

unsigned short Crc(unsigned char *, int);
unsigned short Lrc(unsigned char*, int);

#define CHAR(c)	((c & 0x08) ? '*' : '.')

int state[130];	// 0: T/U ʤ, 4: OFF, 8: ON, C: ޡ
int grp[130];	// group or pattern

int fd;
int Cflg;	// clear group and pattern
int Dflg;	// disable
int Gflg;	// set group
int Rflg;	// reset
int dflg;	// debug
int eflg;	// check error
int gflg;	// get group
int rflg;	// read state
int vflg;	// verbose
int xflg;	// test
char *cmd;
char buf[BUFSIZ];

int main(argc, argv) char **argv;
{
  char *s;
  int i, n;

  cmd = argv[0];
  while (--argc > 0 && (*++argv)[0] == '-' && !isdigit((*argv)[1]))
	for (s = argv[0]+1; *s; s++)
		switch (*s) {
		case 'C':
			Cflg++;
			break;
		case 'D':
			Dflg++;
			break;
		case 'G':
			Gflg++;
			n = 0;
			sscanf(s + 1, "%d", &n);
			s += strlen(s) - 1;
			break;
		case 'R':
			Rflg++;
			break;
		case 'd':
			dflg++;
			break;
		case 'e':
			eflg++;
			break;
		case 'g':
			if (s[1] != '-')
				gflg++;
			n = 0;
			sscanf(s + 1, "%d", &n);
			s += strlen(s) - 1;
			break;
		case 'r':
			rflg++;
			break;
		case 'v':
			vflg++;
			break;
		case 'x':
			xflg++;
			break;
		default:
			Usage();
		}
  if ((fd = serOpen(HOST, PORT)) < 0)
	error("can not open %s", HOST);
  usleep(200000);
  if (Cflg || Dflg || Gflg || Rflg || gflg) {
	if (Cflg)
		clrptgr();
	else if (Dflg)
		disable();
	else if (Gflg) {
		for (i = 0; i < argc; i++) {
			grp[i] = 0;
			sscanf(argv[i], "%d", &grp[i]);
		}
		grp[i] = 0;	
		setgrp(n, grp);
	}
	else if (Rflg)
		reset();
	else if (gflg)
		getgrp(n);
	serClose(fd);
	exit(0);
  }
  if (xflg) {	// test
	printf("%d\n", red(384+2));
//	setgrp(1, 0);	// 
//	setgrp(1, 27, 28, 0);
//	setgrp(1, 2, 3, 4, 5, 0);
//	if (getgrp(1) < 0) ckerror();
//	if (getptn(1) < 0) ckerror();
	serClose(fd);
	exit(0);
  }
//  begin();	// к (٤)
  enq();	// к ()
  if (eflg)
	ckerror();
  else if (rflg) {
	if (argc == 0)
		Red(1, 140);	// all address from 1 to 140
	else {
		for (i = 0; i < argc; i++)
			printf("%s %d\n", argv[i], red(arg2adr(argv[i])));

	}
  }
  else if (argc > 0) {
	for (i = 0; i < argc; i++) {
		s = argv[i];
		if (*s == '-' || isdigit(*s) || *s == 'g') {
			onoff(arg2adr(s));
			usleep(100000);
		}
		else
			fprintf(stderr, "illegal arg: %s\n", argv[i]);
	}
  }
  else {
	while (fgets(buf, sizeof(buf), stdin) != NULL) {
		int c;

		s = buf;
		n = c = 0;
		if (*s == 'g') {
			sscanf(buf + 1, "%d\n", &n);
			if (n > 0)
				n += 384;
			else
				n = -abs(n) - 384;
		}
		else {
			sscanf(buf, "%d %d\n", &n, &c);
			if (c == 0)
				n = -n;
		}
		onoff(n);
		usleep(100000);
	}
  }
  serClose(fd);
}

// *s == "1", "2", .. "-1", "-2", .. "g1", "g2", .. "g-1", "g-2", ..

int arg2adr(s) char *s;
{
  int n = 0;

  if (isdigit(*s))
	n = atoi(s);
  else if (*s == '-') {
	if (isdigit(s[1]))
		n = -atoi(s + 1);
	else if (vflg)
		fprintf(stderr, "ignore %s\n", s);
  }
  else if (*s == 'g') {
	if (isdigit(s[1]))
		n = atoi(s + 1) + 384;
	else if (s[1] == '-' && isdigit(s[2]))
		n = -atoi(s + 2) - 386;
	else if (vflg)
		fprintf(stderr, "ignore %s\n", s);
  }
  else if (vflg)
	fprintf(stderr, "ignore %s\n", s);
  return n;
}

// ѥ󡢥롼ֲ

int clrptgr()
{
  int n;

  sprintf(buf, "U\r");
  if ((n = write(fd, buf, 6)) < 0)
	fprintf(stderr, "write() error.\n");
  n = Recv(fd, buf, sizeof(buf));
  if (vflg)
	dump(buf, n);
  if (*buf == '\006')
	printf("clear pattern and group suceed.\n");
  else
	printf("clear pattern and group failed.\n");
  return 0;
}

// 롼
// ϤΤۤɤ
#if 1
int setgrp(n, grp) int n; int *grp;
{
  int i, k, r, nerr = 0;
  char *s, str[4];

//printf("n(%d)\n", n);
  if (n < 1 || 127 < n) {
	fprintf(stderr, "group address %d out of range\n", n);
	nerr++;
  }
  for (i = 0; i < 256; i++) {
	if (grp[i] == 0)
		break;
	if (grp[i] < 1 || 256 < grp[i]) {
		fprintf(stderr, "address %d out of range\n", grp[i]);
		nerr++;
	}
	printf(" %d", grp[i]);
  }
  printf("\n");
  if (nerr != 0)
	return -1;

  --n;
  s = buf;
  if (n < 64)
	sprintf(s, "S3E%X%d\r", n / 4, n % 4);
  else if (n < 127)
	sprintf(s, "S3F%X%d\r", n / 4, n % 4);
  else {
	fprintf(stderr, "setgrp(%d):  group address out of range.\n", n + 1);
	return-1;
  }
  s += 5;
  for (i = 0; i < 256; i++) {
	sprintf(s, "%X", i % 4);
	s++;
  }
  for (i = 0; i < 16; i++) {
	*s++ = '3';
	*s++ = '0';
  }
  *s++ = '\r';
  k = s - buf;
  *s = '\0';

  for (i = 0; i < 256; i++) {
	if (grp[i] <= 0)
		break;
	s = buf + 5 + (grp[i] - 1);
	sprintf(str, "%X", 8 + (grp[i] - 1) % 4);
	*s = str[0];
  }

  if (vflg)
	printf("%s\n", buf);
//return 0;
  if ((r = write(fd, buf, k)) < 0)
	fprintf(stderr, "write() error.\n");
  fprintf(stderr, "waiting response for 17 sec ..\n");
  sleep(15);
  *buf = '\0';
  r = Recv(fd, buf, sizeof(buf));
//printf("getgrp(): Recv(): %d bytes\n", r);
  if (vflg)
	printf("%s\n", buf);
  if (dflg)
	dump(buf, r);
  if (*buf == '\006')
	fprintf(stderr, "group setting suceed.\n");
  return 0;
}
#else
int setgrp(int n, int ap, ...)
{
  va_list argp;
  int i, k, p, r;
  char *s, str[4];

  --n;
  s = buf;
  if (n < 64)
	sprintf(s, "S3E%X%d\r", n / 4, n % 4);
  else if (n < 127)
	sprintf(s, "S3F%X%d\r", n / 4, n % 4);
  else {
	fprintf(stderr, "setgrp(%d):  group address out of range.\n", n + 1);
	return-1;
  }
  s += 5;
  for (i = 0; i < 256; i++) {
	sprintf(s, "%X", i % 4);
	s++;
  }
  for (i = 0; i < 16; i++) {
	*s++ = '3';
	*s++ = '0';
  }
  *s++ = '\r';
  k = s - buf;
  *s = '\0';
//printf("%s\n", buf);

  va_start(argp, ap);
  p = ap;
  for (;;) {
	if (p <= 0)
		break;
//	printf(" %d", p);
	s = buf + 5 + (p - 1);
	sprintf(str, "%X", 8 + (p - 1) % 4);
	*s = str[0];
	p = (int)va_arg(argp, int);
  }
  va_end(argp);
//  printf("\n");

  if (vflg)
	printf("%s\n", buf);
  if ((n = write(fd, buf, k)) < 0)
	fprintf(stderr, "write() error.\n");
  fprintf(stderr, "waiting response for 17 sec ..\n");
  sleep(15);
  *buf = '\0';
  r = Recv(fd, buf, sizeof(buf));
//printf("getgrp(): Recv(): %d bytes\n", n);
  if (vflg)
	printf("%s\n", buf);
  if (dflg)
	dump(buf, r);
  if (*buf == '\006')
	fprintf(stderr, "group setting suceed.\n");
  return 0;
}
#endif

// 롼׵
//#define N6	// with timer
int getgrp(n) int n;
{
  char *s;
  int i, k, n0, x;
#ifdef N6
  int c;
#endif

  if (n < 1 || 127 < n) {
	fprintf(stderr, "getgrp(%d):  group address out of range.\n", n);
	return -1;
  }
  n0 = n;
  --n;
#ifdef N6
  if (n < 64)
	sprintf(buf, "N6E%X%d\r", n / 4, n % 4);
  else if (n < 127)
	sprintf(buf, "N6F%X%d\r", n / 4, n % 4);
#else
  if (n < 64)
	sprintf(buf, "N3E%X%d\r", n / 4, n % 4);
  else if (n < 127)
	sprintf(buf, "N3F%X%d\r", n / 4, n % 4);
#endif
  else {
	fprintf(stderr, "getgrp(%d):  group address out of range.\n", n + 1);
	return-1;
  }
//printf("n(%d)%s\n", n, buf);
//dump(buf, 6);
  if ((n = write(fd, buf, 6)) < 0)
	fprintf(stderr, "write() error.\n");
  fprintf(stderr, "waiting response for 12 sec ..\n");
  sleep(10);
  *buf = '\0';
  n = Recv(fd, buf, sizeof(buf));
//printf("getgrp(): Recv(): %d bytes\n", n);
  if (vflg)
	printf("%s\n", buf);
  if (dflg)
	dump(buf, n);

  //ɽ
  s = buf + 2;
  sscanf(buf + 2, "%3X", &x);
  k = ((x >> 8) - 0x0E) * 64 + ((x >> 4) & 0x0F) * 4 + (x & 0x0F);
  if (n0 != k + 1)
	fprintf(stderr, "misterious response: CH, SW unmatch.\n");
  printf("G%d", n0);
#ifdef N6
  s = buf + 5;
  for (i = 0; i < 256; i++, s += 2) {
	if ((k = *s) == '0' + (i % 4))
		continue;
	printf(" %d %02X", i + 1, s[1] & 0xFF);
  }
#else
  s = buf + 5;
  for (i = 0; i < 256; i++) {
	if ((k = *s++) == '0' + (i % 4))
		continue;
	printf(" %d", i + 1);
  }
#endif
  for (i = 0; i < 16; i++, s += 2) {
	if (strncmp(s, "30", 2) == 0)
		continue;
	printf(" *%.2s", s);
  }
#ifdef N6
  sscanf(s, "%2X", &x);
  for (s = buf, c = i = 0; i < 5 + 256*2 + 16*2; i++)
	c += *s++ & 0xFF;
  if (0x100 - (c & 0xFF) != x)
	fprintf(stderr, "check sum error.\n");
#endif
  printf("\n");
  return 0;
}

// (ȡ)ѥ׵

int getptn(n)
{
  char *s;
  int i;

  --n;
  if (n < 24)
	sprintf(buf, "N17%X%d\r", n / 4 + 12, n % 4);
  else if (n < 72)
	sprintf(buf, "N15%X%d\r", n / 4, n % 4);
  else {
	fprintf(stderr, "getptn(%d):  pattern address out of range.\n", n + 1);
	return-1;
  }
  if (vflg)
	printf("n(%d)%s\n", n, buf);
//dump(buf, 6);
  if ((n = write(fd, buf, 6)) < 0)
	fprintf(stderr, "write() error.\n");
  sleep(10);
  fprintf(stderr, "waiting response for 12 sec ..\n");
  *buf = '\0';
  n = Recv(fd, buf, sizeof(buf));
//printf("getptn(): Recv(): %d bytes\n", n);
  if (vflg)
	printf("%s\n", buf);
  if (dflg)
	dump(buf, n);
  //  1 - 63
  s = buf + 5;
  for (i = 0; i < 64; i++)
	printf("%2d %.4s\n", i + 1, s + 4 * i);
  // Ĵ 1 - 16
  printf("*%s*\n", s + 4 * i);
  return 0;
}

/*
 * ϩֹ n1  n2 ޤǤζ֤ ON/OFF ֤ɤ߼
 */

int Red(n1, n2)
{
  int h1, l1, h2, l2;
  int i, k, n, m, x, r;
  char *s, adr[8];

  --n1;
  --n2;
  // channel
  n = ((n1 / 64) << 4) + 128 + (n1 % 64) / 4;
  m = ((n2 / 64) << 4) + 128 + (n2 % 64) / 4;
  sprintf(buf, "W2%02X%02X\r", n, m);
  ++n1;
  ++n2;
  if (vflg)
	printf("%s\n", buf);
  if ((n = write(fd, buf, 7)) < 0)
	fprintf(stderr, "write() error.\n");
  *buf = '\0';
  n = Recv(fd, buf, sizeof(buf));
//printf("n(%d)(%s)\n",n, buf);
  buf[n] = '\0';
  if (vflg)
	printf("%s\n", buf);
  m = n - 6;
  n = n1;
  for (i = 0, s = buf + 6; i < m; i++, n++) {
	sscanf(buf + 6 + i, "%1x", &x);
	sprintf(adr, "%d-%d", n / 4, n % 4 + 1);
	x &= 0x0C;
	state[n] = x;
	if (x == 0)
		continue;	// T/U ʤ
	if (! vflg) {
		printf("%3d ", n);
		if (x == 0x04)
			printf("0\n");
		else
			printf("1\n");
	}
	else {
		printf("%3d %s %x ", n, adr, x);
		if (x == 0x0C)
			printf("ޡ\n");
		else if (x == 0x08)
			printf("ON\n");
		else if (x == 0x04)
			printf("OFF\n");
		else
			printf("T/U ʤ\n");
	}
  }
  return 0;
}

/*
 * ϩֹ n  ON/OFF ֤ɤ߼ (롼ץɥ쥹 +384 ǻ)
 */

int red(n)
{
  int h, l, k;
  int m, x, r;

  if (n < 1 || 511 < n) {
	if (vflg)
		fprintf(stderr, "address %d out of range.\n", n);
	return -1;
  }
  n--;
  // ϩֹ -> ͥǡ ch H, L,  No.
  k = ((n / 4 + 128) << 4) + n % 4;
  sprintf(buf, "W1%03X\r", k);
  if (vflg)
	printf("%s\n", buf);
  if ((n = write(fd, buf, 6)) < 0)
	fprintf(stderr, "write() error.\n");
  *buf = '\0';
  n = Recv(fd, buf, sizeof(buf));
  if (vflg)
	printf("%s\n", buf);
  if (n != 6) {
	fprintf(stderr, "Responce error (%d bytes)\n", n);
	return -1;
  }
  sscanf(buf + 4, "%1X", &x);
  x &= 0x0C;
  if (x == 0x0C) {
	r = 2;
	printf("ޡ\n");
  }
  else if (x == 0x08)
	r = 1;
  else if (x == 0x04)
	r = 0;
  else {
	r = -1;
  }
  if (dflg)
	dump(buf, 6);
  return r;
}

/*
 * ON/OFF 
 * 0 < n : ϩ n  ONn < 0 : ϩ n  OFF
 * ̥ɥ쥹     n = 1, 2, .. 256
 * 롼ץɥ쥹 n + 384 (n = 1, 2, .. 127)
 * (0xE00 - 0x800) / 4 = 384
 */

int onoff(n)
{
  int h, l, k, on;
  int m, x;

  if (n < -511 || 511 < n || n == 0) {
	if (vflg)
		fprintf(stderr, "address %d out of range.\n", n);
	return 0;
  }
  on = (n < 0) ? 0 : 1;
  n = abs(n) - 1;
  // ϩֹ -> ͥǡ ch H, L,  No.
  k = ((n / 4 + 128) << 4) + n % 4 + (on ? 0x8 : 0x4);
  sprintf(buf, "T1%03X\r", k);
  if (vflg)
	printf("%s\n", buf);

  if ((n = write(fd, buf, 7)) < 0)
	fprintf(stderr, "write() error.\n");
  *buf = '\0';
  n = Recv(fd, buf, sizeof(buf));
  if (dflg)
	dump(buf, n);
  if (buf[0] == '\006')
	return 0;
  if (buf[0] == '*')
	fprintf(stderr, "error !\n");
  else if (buf[0] != '\025')
	fprintf(stderr, "Unknown response. (0x%02x)\n", buf[0] & 0xff);
  return -1;
}

/*
 * 󥿥եԥ塼Υޥɤ¹Ԥ褦ˤ
 *  Ÿȥꥻåľϥޥɤ̵뤹
 * Ÿư
 *   1) ENQ \r -> ̵
 *   2) @ \r -> ACK \r ( &\r ǤʤENQ \r α
 */

int begin()
{
  int i, n;

//  if ((n = write(fd, "@\r", 2)) < 0)
  if ((n = write(fd, "@", 2)) < 0)
	fprintf(stderr, "write() error.\n");
  // Хåե˻ĤäƤǡǽ˽ФƤ뤳Ȥ
  for (i = 0; i < 3; i++) {
	*buf = '\0';
	n = Recv(fd, buf, sizeof(buf));
	if (vflg)
		dump(buf, n);
	if (strcmp(buf, "&") == 0) {
		return 0;
	}
	else if (*buf == '\006')
		return 0;	// Ż
  }
  fprintf(stderr, "begin(): retry over.\n");
  return -1;
}

/*
 * ػ
 */

int disable()
{
  int n;

  if ((n = write(fd, "$\r", 1)) < 0) {
	fprintf(stderr, "write() error.\n");
	return -1;
  }
  *buf = '\0';
  if ((n = Recv(fd, buf, sizeof(buf))) > 0) {
	if (vflg)
		dump(buf, n);
  }
  fprintf(stderr, "response disabled.\n");
  return 0;
}

/*
 * ǽǧ
 */
// NPort 5450 ˰ΥǡĤ礬

int ckerror()
{
  int i, n, e[4];
  char *s;

  /* ֳǧ */
  if ((n = write(fd, "Q1\r", 3)) < 0) {
	fprintf(stderr, "write() error.\n");
	return -1;
  }
  *buf = '\0';
  if ((n = Recv(fd, buf, sizeof(buf))) > 0) {
	if (vflg) {
		printf("n(%d)(%s)\n",n, buf);
	}
	sscanf(buf + 1, "%2x%2x%2x", &e[0], &e[1], &e[2]);
	if (e[0]) {
		if (e[1] & 0x08)
			fprintf(stderr, "å२顼\n");
		if (e[1] & 0x04)
			fprintf(stderr, "ե졼ߥ󥰥顼\n");
		if (e[1] & 0x02)
			fprintf(stderr, "С󥨥顼\n");
		if (e[1] & 0x01)
			fprintf(stderr, "ѥƥ顼\n");
	}
	if (e[1]) {
		if (e[2] & 0x20)
			fprintf(stderr, "ƥξ\n");
		if (e[2] & 0x10)
			fprintf(stderr, "ѥ󥰥롼\n");
		if (e[2] & 0x08)
			fprintf(stderr, "Хåեե\n");
		if (e[2] & 0x04)
			fprintf(stderr, "׵Хåեե\n");
		if (e[2] & 0x02)
			fprintf(stderr, "ɥ쥹ꥨ顼\n");
		if (e[2] & 0x01)
			fprintf(stderr, "ޥɥ顼\n");
	}
	if (e[2] & ~0x02) {	// ꥻåȥӥåȰʳ
		if (e[3] & 0x80)
			fprintf(stderr, "˥åȰۼ³\n");
		if (e[3] & 0x40)
			fprintf(stderr, "˥åȽǽ\n");
		if (e[3] & 0x10)
			fprintf(stderr, "ǡž\n");
		if (e[3] & 0x08)
			fprintf(stderr, "ƥư\n");
		if (e[3] & 0x04)
			fprintf(stderr, "ƥֳǧԲ\n");
		if (e[3] & 0x02)
			fprintf(stderr, "ꥻå\n");
		if (e[3] & 0x01)
			fprintf(stderr, "\n");
	}
	// reset error status
	for (i = 0; i < 3; i++) {
		if (e[i] == 0x00)
			continue;
		sprintf(buf, "R%d%X%X\r", i + 1,
			(e[i] >> 4) & 0xFF, e[i] & 0xFF);
		if (vflg)
			printf("%s\n", buf);
		if ((n = write(fd, buf, 5)) < 0) {
			fprintf(stderr, "write() error.\n");
			return -1;
		}
		sleep(1);
		*buf = '\0';
		if ((n = Recv(fd, buf, sizeof(buf))) < 0)
			fprintf(stderr, "Recv(): error.\n");
		if (vflg)
			fprintf(stderr, "%s\n", buf);
		if (vflg)
			dump(buf, n);
	}
	return 1;
  }
  return 0;
}

/*
 * 󥿥եޥɤǽɤǧ
 * (Хåե̳ǧ)
 */

int enq()
{
  int i, n;

  if ((n = write(fd, "\005\r", 2)) < 0)
	fprintf(stderr, "write() error.\n");
  for (i = 0; i < 3; i++) {
	*buf = '\0';
	n = Recv(fd, buf, sizeof(buf));
	if (vflg)
		printf("n(%d)(%s)\n", n, buf);
	if (strcmp(buf, "\006") == 0)
		return 0;
	else if (strcmp(buf, "\025") == 0)	// busy
		sleep(3);
	else if (n < 0)
		break;	// no response
  }
  if (vflg)
	fprintf(stderr, "enq(): no response, try to enable response.\n");
  if (begin() == 0)
	return 0;
  if (vflg)
	fprintf(stderr, "begin(): no response, try to rest.\n");

  reset();
  sleep(5);
  return 0;
}

/*
 * 󥿥եꥻåȤ
 */

int reset()
{
  int n;

  printf("Resetting WR3381K ..\n");
  if ((n = write(fd, "#\r", 2)) < 0)
	fprintf(stderr, "write() error.\n");
  *buf = '\0';
  sleep(3);
  n = Recv(fd, buf, sizeof(buf));
//printf("n(%d)(%s)\n",n, buf);
  if (vflg && n >= 0)
	dump(buf, n);
  if (n == 2 && *buf == '\006')
	fprintf(stderr, "reset OK\n");
  usleep(200);
  if ((n = write(fd, "@\r", 2)) < 0)
	fprintf(stderr, "write() error.\n");
  *buf = '\0';
  n = Recv(fd, buf, sizeof(buf));
//printf("n(%d)(%s)\n",n, buf);
  if (vflg && n >= 0)
	dump(buf, n);
  if (n == 2 && strchr(buf, '&') != NULL)
	fprintf(stderr, "response enabled.\n");
  sleep(2);
  return 0;
}

/*
 * 顼ơ׵
 * (CR dekimtter ǤĤ뤫狼ʤ !  Q1 ǥ顼ʤ̵ǡ
 * 	Υǡ)
 */

int ckError()
{
  int i, n;

  for (i = 0; i < 3; i++) {
	if ((n = write(fd, "Q\r", 2)) < 0)
		fprintf(stderr, "write() error.\n");
	*buf = '\0';
	usleep(500000);
	if ((n = Recv(fd, buf, sizeof(buf))) > 0)
		break;
	usleep(500000);
	begin();
	usleep(500000);
  }
  if (vflg)
	printf("%s\n", buf);
  if (i == 3)
	error("ckError() no respopnse.", (char *)0);

  if (n == 5 && strncmp(buf, "E100", 4) == 0)
	return 0;	/* 顼ʤ */

  if (n == 2 && strcmp(buf, "\006") != 0) {
	fprintf(stderr, "reset error\n");
	return -1;
  }
  return 0;
}

/*
 * ޥɱ
 */

int Recv(fd, buf, siz) char *buf;
{
  char c, *s;
  int i, k, n;

  alarm(4);
  n = 0;
  s = buf;
  while (n < siz) {
	if ((k = read(fd, s, siz)) <= 0) {
		if (vflg)
			perror("Recv(): read() error: ");
	        return -1;
	}
	*(s + k) = '\0';
	if (vflg)
		printf("Recv(): %d\n", k);
	for (i = 0; i < k; i++) {
		n++;
		c = *s & 0xff;
//printf("i(%d), %02x (%c)\n", i, c, c <= 0x1f ? ' ' : c);
		if (*s++ == '\r') {
			*--s = '\0';
			return n;
		}
	}
  }
  return n;
}

/*
 * ǡʤɤ 16 ʥ
 */

int dump(s, n) char *s;
{
  int i;

  for (i = 0; i < n; i++) {
	if (0 < i)
		printf(" ");
	printf("%02X", s[i] & 0xFF);
  }
  printf("\n");
  return 0;
}

void error(s, t) char *s, *t;
{
  fprintf(stderr, "%s: ", cmd);
  fprintf(stderr, s, t);
  fprintf(stderr, "\n");
  exit(1);
}

void Usage()
{
  static char *t[] = {
"ޥ	%s - Panasonic ե룲⥳",
"ʸ		%s [ץ] [ޥ]",
"ץ	-v	# ǥХåɽ",
" -C			# 롼פȥѥƤ򥯥ꥢ",
" -Gn a1, a2, ..	# 롼ץɥ쥹 n ٥ɥ쥹 1 - 127 Ƥ",
" -c			# ϩ֤ǧ",
" -gn			# 롼ץɥ쥹 n γƤĴ٤",
" -r			# ٤ ON/OFFĴ٤",
" -r a1, a2, ..		# a1, a2, ..  ON/OFFĴ٤",
"",
" %s 109 114		# 109  114  ON",
" %s -109 -114		# 109  114  OFF",
" %s g1 g-2		# p 1  ON롼 2  OFF",
" %s -G1 27 28		# 롼 1  27  27 ",
"ON/OFF 楳ޥɤ ON/OFF ֲϩֹפʸǶڤäƻꤷ",
"ʤ OFFʤ ON ˤʤޤ̲ϩβϩֹ 1  256 ޤǡ",
"롼ֹ 1  127 ޤǤΥץǥ롼פ ON/OFF ",
"Ԥϥ롼ֹ 384 ûͤꤹ뤫Ƭ g ʸղä",
"롼ֹꤷޤ",
"⥪ץꤷʤɸϤ鲼Υޥɤɤ߼ä",
"¹Ԥޤ",
" n control",
" ..",
"n (0 < n) ϲϩֹ桢control (0 ޤ 1) ǡꤷϩ 0 o",
"OFF1  ON ˤޤ",
  NULL
  };
  int i;

  for (i = 0; t[i] != NULL; i++) {
	fprintf(stderr, t[i], cmd);
	fprintf(stderr, "\n");
  }
  exit(1);
}
